/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.events;

import dev.xkmc.l2library.init.events.GeneralEventHandler;
import dev.xkmc.youkaishomecoming.compat.curios.CuriosManager;
import dev.xkmc.youkaishomecoming.content.block.variants.LeftClickBlock;
import dev.xkmc.youkaishomecoming.content.capability.FrogGodCapability;
import dev.xkmc.youkaishomecoming.content.capability.KoishiAttackCapability;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiEntity;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.FlyingToken;
import dev.xkmc.youkaishomecoming.content.item.curio.hat.TouhouHatItem;
import dev.xkmc.youkaishomecoming.content.spell.item.SpellContainer;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.events.ReimuEventHandlers;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.tag.ForgeTags;

@Mod.EventBusSubscriber(modid="youkaishomecoming", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GeneralEventHandlers {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player e = event.player;
        if (e.m_21023_((MobEffect)YHEffects.FAIRY.get()) && CuriosManager.hasAnyWings((LivingEntity)e)) {
            FlyingToken.tickFlying(e);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        LeftClickBlock block;
        BlockPos pos;
        if (event.getItemStack().m_150930_(Items.f_42751_)) {
            return;
        }
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos = event.getPos());
        Block block2 = state.m_60734_();
        if (block2 instanceof LeftClickBlock && (block = (LeftClickBlock)block2).leftClick(state, level, pos, event.getEntity())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.CONSUME);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity;
        if (event.getDamageSource().m_276093_(YHDamageTypes.KOISHI) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            ((KoishiAttackCapability)KoishiAttackCapability.HOLDER.get(player)).onBlock();
        }
        if ((livingEntity = event.getDamageSource().m_7640_()) instanceof RumiaEntity) {
            RumiaEntity rumia = (RumiaEntity)livingEntity;
            rumia.state.onBlocked();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void collectBlood(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            SpellContainer.clear(player);
        }
        if (!event.getEntity().m_6095_().m_204039_(YHTagGen.FLESH_SOURCE)) {
            return;
        }
        livingEntity = event.getSource().m_7639_();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity le = livingEntity;
            if (le.m_21205_().m_204117_(ForgeTags.TOOLS_KNIVES) && EffectEventHandlers.isYoukai(le)) {
                GeneralEventHandlers.spawnBlood(le);
            }
            if (le.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)YHItems.RUMIA_HAIRBAND.get())) {
                GeneralEventHandlers.spawnBlood(le);
            }
        }
    }

    private static void spawnBlood(LivingEntity le) {
        if (!le.m_21206_().m_150930_(Items.f_42590_)) {
            return;
        }
        le.m_21206_().m_41774_(1);
        if (le instanceof Player) {
            Player player = (Player)le;
            player.m_150109_().m_36054_(YHItems.BLOOD_BOTTLE.asStack(1));
        } else {
            le.m_19983_(YHItems.BLOOD_BOTTLE.asStack(1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        Object e;
        Entity entity;
        if (event.getSource().m_276093_(YHDamageTypes.DANMAKU) && (entity = event.getSource().m_7639_()) instanceof YoukaiEntity) {
            e = (YoukaiEntity)entity;
            LivingEntity le = event.getEntity();
            double min = ((YoukaiEntity)e).percentageDamage(le);
            if ((double)event.getAmount() < (double)le.m_21233_() * min) {
                event.setAmount(le.m_21233_() * (float)min);
            }
        }
        if ((livingEntity = event.getEntity()) instanceof AbstractVillager) {
            ServerPlayer sp;
            e = (AbstractVillager)livingEntity;
            if (((Boolean)YHModConfig.COMMON.reimuSummonKill.get()).booleanValue() && (livingEntity = event.getSource().m_7639_()) instanceof ServerPlayer && EffectEventHandlers.isYoukai((LivingEntity)(sp = (ServerPlayer)livingEntity))) {
                GeneralEventHandler.schedule(() -> GeneralEventHandlers.lambda$onDamage$0((AbstractVillager)e, sp));
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            FrogGodCapability.startTracking(frog, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        LivingEntity le;
        Entity entity;
        if (event.getEntity() instanceof Villager && ((Boolean)YHModConfig.COMMON.reimuSummonKill.get()).booleanValue() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && EffectEventHandlers.isYoukai(le = (LivingEntity)entity)) {
            ReimuEventHandlers.triggerReimuResponse(le, 16, false);
        }
    }

    public static boolean preventPhantomSpawn(ServerPlayer player) {
        return player.m_21023_((MobEffect)YHEffects.SOBER.get());
    }

    public static boolean supressVibration(Entity self) {
        TraceableEntity item;
        Entity entity;
        if (self instanceof TraceableEntity && (entity = (item = (TraceableEntity)self).m_19749_()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            self = le;
        }
        if (self instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)self;
            return le.m_21023_((MobEffect)YHEffects.UDUMBARA.get());
        }
        return false;
    }

    public static DamageSource modifyDamageType(LivingEntity le, DamageSource type, IYHDanmaku danmaku) {
        ItemStack stack = le.m_6844_(EquipmentSlot.HEAD);
        Item item = stack.m_41720_();
        if (item instanceof TouhouHatItem) {
            TouhouHatItem hat = (TouhouHatItem)item;
            return hat.modifyDamageType(stack, le, danmaku, type);
        }
        return type;
    }

    private static /* synthetic */ void lambda$onDamage$0(AbstractVillager e, ServerPlayer sp) {
        if (e.m_6084_()) {
            ReimuEventHandlers.hurtWarn(sp);
        }
    }
}

